

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of DELAY is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(IN1_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;